/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames;

import com.mojang.brigadier.CommandDispatcher;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.level.LevelComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.level.LevelComponentInitializer;
import io.github.overlordsiii.villagernames.api.PiglinNameManager;
import io.github.overlordsiii.villagernames.api.RaiderNameManager;
import io.github.overlordsiii.villagernames.api.VillagerNameManager;
import io.github.overlordsiii.villagernames.command.VillagerNameCommand;
import io.github.overlordsiii.villagernames.config.VillagerConfig;
import io.github.overlordsiii.villagernames.integration.cca.IntComponent;
import io.github.overlordsiii.villagernames.integration.cca.RavagerCounterComponent;
import io.github.overlordsiii.villagernames.util.NamesLoader;
import io.github.overlordsiii.villagernames.util.VillagerUtil;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1439;
import net.minecraft.class_1584;
import net.minecraft.class_1646;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3134;
import net.minecraft.class_3763;
import net.minecraft.class_3989;
import net.minecraft.class_5418;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillagerNames
implements ModInitializer,
LevelComponentInitializer {
    public static ConfigManager<VillagerConfig> CONFIG_MANAGER;
    public static VillagerConfig CONFIG;
    public static final Logger LOGGER;
    public static final ComponentKey<IntComponent> INT_COMPONENT;

    public void onInitialize() {
        try {
            NamesLoader.load();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Error while loading default names");
            e.printStackTrace();
        }
        CommandRegistrationCallback.EVENT.register((commandDispatcher, dedicated) -> {
            VillagerNameCommand.register((CommandDispatcher<class_2168>)commandDispatcher);
            if (!dedicated) {
                class_3134.method_13675((CommandDispatcher)commandDispatcher);
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            if (entity instanceof class_1646) {
                class_1646 villagerEntity = (class_1646)entity;
                VillagerUtil.createVillagerNames(villagerEntity);
                VillagerUtil.generalVillagerUpdate(villagerEntity);
                return;
            }
            if (entity instanceof class_1439) {
                class_1439 ironGolemEntity = (class_1439)entity;
                VillagerUtil.loadGolemNames(ironGolemEntity);
                VillagerUtil.updateGolemNames(ironGolemEntity);
                return;
            }
            if (entity instanceof class_3989) {
                class_3989 wanderingTraderEntity = (class_3989)entity;
                VillagerUtil.createWanderingTraderNames(wanderingTraderEntity);
                VillagerUtil.updateWanderingTraderNames(wanderingTraderEntity);
                return;
            }
            if (entity instanceof class_5418) {
                class_5418 piglinEntity = (class_5418)entity;
                if (VillagerNames.CONFIG.villagerGeneralConfig.piglinNames) {
                    VillagerUtil.createPiglinNames(piglinEntity);
                    VillagerUtil.updatePiglinNames(piglinEntity);
                    return;
                }
            }
            if (entity instanceof class_3763) {
                class_3763 raiderEntity = (class_3763)entity;
                if (!(entity instanceof class_1584) && VillagerNames.CONFIG.villagerGeneralConfig.illagerEntityNames) {
                    VillagerUtil.createIllagerNames(raiderEntity);
                    VillagerUtil.updateIllagerNames(raiderEntity);
                    return;
                }
            }
            if (!VillagerNames.CONFIG.villagerGeneralConfig.illagerEntityNames) return;
            if (!(entity instanceof class_1584)) return;
            class_1584 ravagerEntity = (class_1584)entity;
            VillagerUtil.createRavagerNames(serverWorld, ravagerEntity);
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!world.method_8608() && FabricLoader.getInstance().isDevelopmentEnvironment()) {
                if (entity instanceof VillagerNameManager) {
                    VillagerNameManager manager = (VillagerNameManager)entity;
                    System.out.println("villager debug info");
                    System.out.println("villager first name: " + manager.getFirstName());
                    System.out.println("Villager last name: " + manager.getLastName());
                    System.out.println("Villager profession: " + manager.getProfessionName());
                    System.out.println("Villager is child: " + ((class_1646)entity).method_6109());
                    System.out.println("Villager full name: " + manager.getFullName());
                    System.out.println("Villager player name: " + manager.getPlayerName());
                } else if (entity instanceof RaiderNameManager) {
                    RaiderNameManager manager = (RaiderNameManager)entity;
                    System.out.println("illager debug info");
                    System.out.println("illager first name: " + manager.getFirstName());
                    System.out.println("illager last name: " + manager.getLastName());
                    System.out.println("illager title: " + manager.getTitle());
                    System.out.println("illager full name: " + manager.getFullName());
                    System.out.println("illager player name: " + manager.getPlayerName());
                } else if (entity instanceof PiglinNameManager) {
                    PiglinNameManager manager = (PiglinNameManager)entity;
                    manager.debug();
                }
            }
            return class_1269.field_5811;
        });
    }

    public void registerLevelComponentFactories(LevelComponentFactoryRegistry registry) {
        registry.register(INT_COMPONENT, worldProperties -> new RavagerCounterComponent());
    }

    static {
        LOGGER = LogManager.getLogger(VillagerNames.class);
        INT_COMPONENT = ComponentRegistry.getOrCreate((class_2960)new class_2960("villagernames", "intcomponent"), IntComponent.class);
        CONFIG_MANAGER = (ConfigManager)AutoConfig.register(VillagerConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        CONFIG = (VillagerConfig)AutoConfig.getConfigHolder(VillagerConfig.class).getConfig();
    }
}

